/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.listener;

import java.util.ArrayList;
import java.util.List;
import org.codefilarete.stalactite.engine.listener.PersistListener;

public class PersistListenerCollection<C>
implements PersistListener<C> {
    private final List<PersistListener<C>> persistListeners = new ArrayList<PersistListener<C>>();

    public List<PersistListener<C>> getPersistListeners() {
        return this.persistListeners;
    }

    @Override
    public void beforePersist(Iterable<? extends C> entities) {
        this.persistListeners.forEach(listener -> listener.beforePersist(entities));
    }

    @Override
    public void afterPersist(Iterable<? extends C> entities) {
        this.persistListeners.forEach(listener -> listener.afterPersist(entities));
    }

    @Override
    public void onPersistError(Iterable<? extends C> entities, RuntimeException runtimeException) {
        this.persistListeners.forEach(listener -> listener.onPersistError(entities, runtimeException));
    }

    public void add(PersistListener<? extends C> persistListener) {
        this.persistListeners.add(persistListener);
    }

    public void moveTo(PersistListenerCollection<C> persisTListener) {
        persisTListener.persistListeners.addAll(this.persistListeners);
        this.persistListeners.clear();
    }
}

